/*
 * FinalProjectFairComDisplay.c
 *
 *  Created on: May 9, 2015
 *      Author: jcmx9
 */

#ifdef _WIN32_WCE
#undef UNICODE
#undef _UNICODE
#define main my_main
#endif


/* Preprocessor definitions and includes */

#include "ctdbsdk.h" 		// c-tree headers
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <sys/types.h>
#include <sys/stat.h>		//for open()/write() mode
#include <fcntl.h>			//for open()/write()
#include <err.h>			//for open() error test
#include <sys/time.h>		//for time() function
#include <unistd.h>
#include <sys/select.h>		//for select() function

#define END_OF_FILE INOT_ERR  /* INOT_ERR is ctree's 101 error. See cterrc.h */


/* Global declarations */

CTHANDLE hSession;
CTHANDLE hDatabase;
CTHANDLE hTable;
CTHANDLE hRecord;

/* Function declarations */

#ifdef PROTOTYPE
VOID Initialize(VOID), Define(VOID), Manage(VOID), Done(VOID);
VOID Display_Records(VOID);
VOID Delete_Records(CTHANDLE), Check_Table_Mode(CTHANDLE);
VOID Handle_Error(CTSTRING);
VOID error (const char *msg);
#else
VOID Initialize(), Define(), Manage(), Done();
VOID Add_Records(), Display_Records(), Add_Timestamps_Record (), ReadDistanceChange ();
VOID Delete_Records(), Check_Table_Mode();
VOID Handle_Error();
VOID error (msg);
#endif


/*
 * main()
 *
 * The main() function implements the concept of "init, define, manage
 * and you're done..."
 */

#ifdef PROTOTYPE
NINT main (NINT argc, pTEXT argv[])
#else
NINT main (argc, argv)
NINT argc;
TEXT argv[];
#endif
{
   Initialize();

   Define();

   Manage();

   Done();

   printf("\nPress <ENTER> key to exit . . .\n");
#ifndef ctPortWINCE
   getchar();
#endif

   return(0);
}


/*
 * Initialize()
 *
 * Perform the minimum requirement of logging onto the c-tree Server
 */

#ifdef PROTOTYPE
VOID Initialize(VOID)
#else
VOID Initialize()
#endif
{
   CTDBRET  retval;

   printf("INIT\n");

   if ((retval = ctdbStartDatabaseEngine())) 				//using the Server DLL model to start the underlying Server.
	Handle_Error("Initialize(): ctdbStartDatabaseEngine()");

   /* allocate session handle */
   if ((hSession = ctdbAllocSession(CTSESSION_CTREE)) == NULL)		//allocate session
      Handle_Error("Initialize(): ctdbAllocSession()");

   hDatabase = hSession; /* database not used in this tutorial */

   /* connect to server */
   printf("\tLogon to server...\n");
   if (ctdbLogon(hSession, "FAIRCOMS", "ADMIN", "ADMIN"))			//login database by default id and passcode
      Handle_Error("Initialize(): ctdbLogon()");
}


/*
 * Define()
 *
 * Open the table, if it exists. Otherwise create and open the table
 */

#ifdef PROTOTYPE
VOID Define(VOID)
#else
VOID Define()
#endif
{
	CTDBRET  retval;
	CTHANDLE hField1, hField2;

   printf("DEFINE\n");

   /* allocate a table handle */
   if ((hTable = ctdbAllocTable(hDatabase)) == NULL)
	   Handle_Error("Define(); ctdbAllocTable()");

   /* open table */
   printf("\tOpen table...\n");
   if (ctdbOpenTable(hTable, "TimeStamp", CTOPEN_NORMAL))			//Table Name: TimeStamp
   {
      /* define table fields */
      printf("\tAdd fields...\n");
      hField1 = ctdbAddField(hTable, "Date", CT_STRING, 15);		//CT_STRING, char* type to store date string
      hField2 = ctdbAddField(hTable, "Time", CT_STRING, 15);		//CT_STRING, char* type to store time string

      if (!hField1 || !hField2)
         Handle_Error("Define(); ctdbAddField()");					//error check

      /* create table */
      printf("\tCreate table...\n");
      if (ctdbCreateTable(hTable, "TimeStamp", CTOPEN_NORMAL))		//if the table does not exist, create one
         Handle_Error("Define(); ctdbCreateTable()");

      if (ctdbOpenTable(hTable, "TimeStamp", CTOPEN_NORMAL))
         Handle_Error("Define(); ctdbOpenTable()");
   }
   else
   {
      Check_Table_Mode(hTable);
   }

}

/*
 * Manage()
 *
 * This function performs simple record functions of add, delete and gets
 */

#ifdef PROTOTYPE
VOID Manage(VOID)
#else
VOID Manage()
#endif
{
   printf("MANAGE\n");

   /* allocate a record handle */
   if ((hRecord = ctdbAllocRecord(hTable)) == NULL)			//allocate a record handler to operate record
      Handle_Error("Manage(): ctdbAllocRecord()");

   //no need to delete record because we are going to display records

   /* display contents of table */
   Display_Records();
}


/*
 * Done()
 *
 * This function handles the housekeeping of closing tables and
 * freeing of associated memory
 */

#ifdef PROTOTYPE
VOID Done(VOID)
#else
VOID Done()
#endif
{
   printf("DONE\n");

   /* close table */
   printf("\tClose table...\n");
   if (ctdbCloseTable(hTable))							//close table first
      Handle_Error("Done(): ctdbCloseTable()");

   /* logout */
   printf("\tLogout...\n");
   if (ctdbLogout(hSession))							//logout the session
      Handle_Error("Done(): ctdbLogout()");				//no "database" is created or open in this case so don't need close

   /* free handles */
   ctdbFreeRecord(hRecord);								//free record handler
   ctdbFreeTable(hTable);								//free table handler
   ctdbFreeDatabase(hDatabase);							//free databaes handler
   ctdbFreeSession(hSession);							//free session handler

   //if we are linked to the Server DLL, then we should stop our Server at the end of the program.
   ctdbStopDatabaseEngine();		//stop database engine because we are linked to the Server DLL before
}


/*
 * Check_Table_Mode()
 *
 * Check if existing table has transaction processing flag enabled.
 * If a table is under transaction processing control, ctdbGetError()modify the
 * table mode to disable transaction processing
 */

#ifdef PROTOTYPE
VOID Check_Table_Mode(CTHANDLE hTable)
#else
VOID Check_Table_Mode(hTable)
CTHANDLE hTable;
#endif
{
   CTCREATE_MODE mode;

   /* get table create mode */
   mode = ctdbGetTableCreateMode(hTable);

   /* check if table is under transaction processing control */
   if ((mode & CTCREATE_TRNLOG))
   {
      /* change file mode to disable transaction processing */
      mode ^= CTCREATE_TRNLOG;
      if (ctdbUpdateCreateMode(hTable, mode) != CTDBRET_OK)
         Handle_Error("Check_Table_Mode(); ctdbUpdateCreateMode");
   }
}

/*
 * Display_Records()
 *
 * This function displays the contents of a table. ctdbFirstRecord() and
 * ctdbNextRecord() fetch the record. Then each field is parsed and displayed
 */

#ifdef PROTOTYPE
VOID Display_Records(VOID)
#else
VOID Display_Records()
#endif
{
   CTDBRET  retval;
   TEXT     nowdate[15+1];
   TEXT     nowtime[15+1];

   printf("\tDisplay records...");

   /* read first record */
   retval = ctdbFirstRecord(hRecord);		//point the record handler to the first record
   if (retval != CTDBRET_OK)
      Handle_Error("Display_Records(): ctdbFirstRecord()");			//if the table is empty

   while (retval != END_OF_FILE)
   {
      retval = 0;
      //retrieve the data in table as string
      retval |= ctdbGetFieldAsString(hRecord, 0, nowdate, sizeof (nowdate));
      retval |= ctdbGetFieldAsString(hRecord, 1, nowtime, sizeof (nowtime));
      if (retval)
         Handle_Error("Display_Records(): ctdbGetFieldAsString()");

      printf("\n\t\t%s%s\n", nowdate, nowtime);

      /* read next record */
      retval = ctdbNextRecord(hRecord);						//point the record handler to the next record
      if (retval == END_OF_FILE)
         break;   /* reached end of file */

      if (retval != CTDBRET_OK)
         Handle_Error("Display_Records(): ctdbNextRecord()");
   }
}


/*
 * Handle_Error()
 *
 * This function is a common bailout routine. It displays an error message
 * allowing the user to acknowledge before terminating the application
 */

#ifdef PROTOTYPE
VOID Handle_Error(CTSTRING errmsg)
#else
VOID Handle_Error(errmsg)
CTSTRING errmsg;
#endif
{
   printf("\nERROR: [%d] - %s \n", ctdbGetError(hSession), errmsg);
   printf("*** Execution aborted *** \nPress <ENTER> key to exit...");

   ctdbLogout(hSession);

   ctdbFreeRecord(hRecord);
   ctdbFreeTable(hTable);
   ctdbFreeSession(hSession);

   getchar();

   exit(1);
}

/*
 * error()
 *
 * This function handles error message in ReadDistanceChange();
 *
 */
#ifdef PROTOTYPE
VOID error (const char *msg)
#else
VOID error (msg)
#endif
{
    perror(msg);
    exit(0);
}

/* end of FinalProjectFairComDisplay.c */
